import React, { type ReactElement } from 'react';
import type { DragController } from './types';
type ErrorBoundaryProps = {
    children: ReactElement;
    contextId: string;
    dragController: DragController;
};
/**
 * Cancels drags when errors occur.
 */
export declare class ErrorBoundary extends React.Component<ErrorBoundaryProps> {
    componentDidCatch(err: Error): void;
    static getDerivedStateFromError(): void;
    render(): React.JSX.Element;
}
export {};
