import React, { createContext, useContext, useMemo } from 'react';
import { rbdInvariant } from './rbd-invariant';
var DragDropContext = /*#__PURE__*/createContext(null);
export function useDragDropContext() {
  var value = useContext(DragDropContext);
  rbdInvariant(value !== null, 'Unable to find DragDropContext context');
  return value;
}
export function DragDropContextProvider(_ref) {
  var children = _ref.children,
    contextId = _ref.contextId,
    getDragState = _ref.getDragState,
    startKeyboardDrag = _ref.startKeyboardDrag,
    droppableRegistry = _ref.droppableRegistry;
  var value = useMemo(function () {
    return {
      contextId: contextId,
      getDragState: getDragState,
      startKeyboardDrag: startKeyboardDrag,
      droppableRegistry: droppableRegistry
    };
  }, [contextId, getDragState, startKeyboardDrag, droppableRegistry]);
  return /*#__PURE__*/React.createElement(DragDropContext.Provider, {
    value: value
  }, children);
}