"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findDragHandle = findDragHandle;
var _attributes = require("./attributes");
var _findElement = require("./find-element");
/**
 * Obtains the `HTMLElement` with the data attribute passed down through
 * `provided.dragHandleProps`
 */
function findDragHandle(_ref) {
  var contextId = _ref.contextId,
    draggableId = _ref.draggableId;
  // Otherwise the drag handle is a descendant.
  return (0, _findElement.findElement)({
    attribute: _attributes.attributes.dragHandle.contextId,
    value: contextId
  }, {
    attribute: _attributes.attributes.dragHandle.draggableId,
    value: draggableId
  });
}