"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePointerControls = usePointerControls;
var _react = require("react");
var _pragmaticDragAndDropReactBeautifulDndAutoscroll = require("@atlaskit/pragmatic-drag-and-drop-react-beautiful-dnd-autoscroll");
var _adapter = require("@atlaskit/pragmatic-drag-and-drop/element/adapter");
var _preventUnhandled = require("@atlaskit/pragmatic-drag-and-drop/prevent-unhandled");
var _data = require("../../draggable/data");
var _data2 = require("../../droppable/data");
var _draggableLocation = require("../draggable-location");
var _rbdInvariant = require("../rbd-invariant");
/**
 * Sets up listeners for pointer dragging.
 */
function usePointerControls(_ref) {
  var dragController = _ref.dragController,
    contextId = _ref.contextId;
  var updatePointerDrag = (0, _react.useCallback)(function (location) {
    dragController.updateDrag({
      targetLocation: (0, _draggableLocation.getDraggableLocation)(location.current)
    });
  }, [dragController]);
  (0, _react.useEffect)(function () {
    return (0, _adapter.monitorForElements)({
      canMonitor: function canMonitor(_ref2) {
        var initial = _ref2.initial,
          source = _ref2.source;
        if (!(0, _data.isDraggableData)(source.data)) {
          // not dragging something from the migration layer
          // we should not monitor it
          return false;
        }
        var isValidDraggable = source.data.contextId === contextId;
        if (!isValidDraggable) {
          return false;
        }
        var droppable = initial.dropTargets.find(function (target) {
          return (0, _data2.isDroppableData)(target.data);
        });
        if (!droppable) {
          /**
           * There may be no droppable in the `dropTargets` if it is disabled.
           *
           * This is still valid.
           */
          return true;
        }
        var isValidDroppable = droppable.data.contextId === contextId;
        return isValidDroppable;
      },
      onDragStart: function onDragStart(_ref3) {
        var location = _ref3.location,
          source = _ref3.source;
        _pragmaticDragAndDropReactBeautifulDndAutoscroll.autoScroller.start({
          input: location.current.input
        });

        /**
         * We use `preventUnhandled` because we are rendering a custom drag
         * preview.
         */
        _preventUnhandled.preventUnhandled.start();
        var data = source.data;
        (0, _rbdInvariant.rbdInvariant)((0, _data.isDraggableData)(data));
        var draggableId = data.draggableId,
          droppableId = data.droppableId,
          getIndex = data.getIndex,
          type = data.type;
        dragController.startDrag({
          draggableId: draggableId,
          type: type,
          getSourceLocation: function getSourceLocation() {
            return {
              droppableId: droppableId,
              index: getIndex()
            };
          },
          sourceElement: source.element,
          mode: 'FLUID'
        });
      },
      onDrag: function onDrag(_ref4) {
        var location = _ref4.location;
        _pragmaticDragAndDropReactBeautifulDndAutoscroll.autoScroller.updateInput({
          input: location.current.input
        });
        updatePointerDrag(location);
      },
      onDropTargetChange: function onDropTargetChange(_ref5) {
        var location = _ref5.location;
        updatePointerDrag(location);
      },
      onDrop: function onDrop() {
        _pragmaticDragAndDropReactBeautifulDndAutoscroll.autoScroller.stop();
        _preventUnhandled.preventUnhandled.stop();
        dragController.stopDrag({
          reason: 'DROP'
        });
      }
    });
  }, [dragController, contextId, updatePointerDrag]);
}