// Source: https://github.com/atlassian/react-beautiful-dnd

const isEqual = base => value => base === value;
const isScroll = isEqual('scroll');
const isAuto = isEqual('auto');
const isEither = (overflow, fn) => fn(overflow.overflowX) || fn(overflow.overflowY);
const isElementScrollable = el => {
  const style = window.getComputedStyle(el);
  const overflow = {
    overflowX: style.overflowX,
    overflowY: style.overflowY
  };
  return isEither(overflow, isScroll) || isEither(overflow, isAuto);
};
export const getClosestScrollableElement = el => {
  // cannot do anything else!
  if (!el) {
    return null;
  }

  // not allowing us to go higher then body
  if (el === document.body || el === document.documentElement) {
    return null;
  }
  if (!isElementScrollable(el)) {
    // keep recursing
    return getClosestScrollableElement(el.parentElement);
  }

  // success!
  return el;
};