import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _get from "@babel/runtime/helpers/get";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import _regeneratorRuntime from "@babel/runtime/regenerator";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
import { _getFullUserHash, _getStorageKey, DataAdapterCachePrefix, DataAdapterCore, StableID } from '@statsig/js-client';

/**
 * Data adapter which only uses bootstrap data and will never fetch from network or cache.
 * We do this because we control the fetching of bootstrap data from FFS in Client.ts whereas the
 * default data adapter fetches from Statsig servers.
 */
export var NoFetchDataAdapter = /*#__PURE__*/function (_DataAdapterCore) {
  function NoFetchDataAdapter() {
    var _this;
    _classCallCheck(this, NoFetchDataAdapter);
    _this = _callSuper(this, NoFetchDataAdapter, ['NoFetchDataAdapter', 'nofetch']);
    _defineProperty(_this, "bootstrapResult", null);
    return _this;
  }

  /**
   * Make sure to call this **before** calling `initializeAsync` or `updateUserAsync` but
   * after the Statsig client has been created!
   */
  _inherits(NoFetchDataAdapter, _DataAdapterCore);
  return _createClass(NoFetchDataAdapter, [{
    key: "setBootstrapData",
    value: function setBootstrapData(data) {
      this.bootstrapResult = data ? {
        source: 'Bootstrap',
        data: JSON.stringify(data),
        receivedAt: Date.now(),
        stableID: StableID.get(this._getSdkKey()),
        fullUserHash: null
      } : null;
    }
  }, {
    key: "prefetchData",
    value: function () {
      var _prefetchData = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_user, _options) {
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function prefetchData(_x, _x2) {
        return _prefetchData.apply(this, arguments);
      }
      return prefetchData;
    }()
  }, {
    key: "getDataAsync",
    value: function () {
      var _getDataAsync = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(_current, user, _options) {
        return _regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", this.bootstrapResult && _objectSpread(_objectSpread({}, this.bootstrapResult), {}, {
                fullUserHash: _getFullUserHash(user)
              }));
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getDataAsync(_x3, _x4, _x5) {
        return _getDataAsync.apply(this, arguments);
      }
      return getDataAsync;
    }()
  }, {
    key: "getDataSync",
    value: function getDataSync(user) {
      return this.bootstrapResult && _objectSpread(_objectSpread({}, this.bootstrapResult), {}, {
        fullUserHash: _getFullUserHash(user)
      });
    }
  }, {
    key: "_fetchFromNetwork",
    value: function () {
      var _fetchFromNetwork2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(_current, _user, _options) {
        return _regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              return _context3.abrupt("return", null);
            case 1:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function _fetchFromNetwork(_x6, _x7, _x8) {
        return _fetchFromNetwork2.apply(this, arguments);
      }
      return _fetchFromNetwork;
    }()
  }, {
    key: "_getCacheKey",
    value: function _getCacheKey(user) {
      // Same logic as default data adapter
      // https://github.com/statsig-io/js-client-monorepo/blob/main/packages/js-client/src/StatsigEvaluationsDataAdapter.ts
      var key = _getStorageKey(this._getSdkKey(), user);
      return "".concat(DataAdapterCachePrefix, ".").concat(this._cacheSuffix, ".").concat(key);
    }
  }, {
    key: "_isCachedResultValidFor204",
    value: function _isCachedResultValidFor204(_result, _user) {
      return false;
    }
  }, {
    key: "setDataLegacy",
    value: function setDataLegacy(data, user) {
      _superPropGet(NoFetchDataAdapter, "setData", this, 3)([data, user]);
    }

    // Do not stringify options property since that includes this adapter and will
    // cause a circular reference when Statsig sends diagnostic events and including
    // values is not necessary and makes the result huge
  }, {
    key: "toJSON",
    value: function toJSON() {
      var result = _objectSpread({}, this);
      delete result._options;
      delete result._inMemoryCache;
      delete result.bootstrapResult;
      return result;
    }
  }]);
}(DataAdapterCore);