/**
 * Handle controlled & uncontrolled component state
 *
 * ```js
 *  const [uncontrolledState, setUncontrolledState] = useControlled(
 *    controlledValue,
 *    () => defaultValue,
 *  );
 * ```
 *
 * @param propValue
 * @param getDefaultPropValue
 */
export default function useControlled<T>(propValue: T | undefined, getDefaultPropValue?: () => T): readonly [
    T,
    (newValue: T) => void
];
