import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import React, { useCallback, useMemo } from 'react';
import { default as AnalyticsReactContext } from '@atlaskit/analytics-next-stable-react-context';
import { useAnalyticsContext } from '../../hooks/useAnalyticsContext';
import { useTrackedRef } from '../../hooks/useTrackedRef';
var AnalyticsListener = function AnalyticsListener(_ref) {
  var children = _ref.children,
    channel = _ref.channel,
    onEvent = _ref.onEvent;
  var _useAnalyticsContext = useAnalyticsContext(),
    _useAnalyticsContext$ = _useAnalyticsContext.getAtlaskitAnalyticsEventHandlers,
    getAtlaskitAnalyticsEventHandlers = _useAnalyticsContext$ === void 0 ? function () {
      return [];
    } : _useAnalyticsContext$,
    getAtlaskitAnalyticsContext = _useAnalyticsContext.getAtlaskitAnalyticsContext;
  var onEventRef = useTrackedRef(onEvent);
  var channelRef = useTrackedRef(channel);
  var getAnalyticsEventHandlers = useCallback(function () {
    var thisHandler = function thisHandler(event, eventChannel) {
      if (channelRef.current === '*' || channelRef.current === eventChannel) {
        onEventRef.current(event, eventChannel);
      }
    };
    return [thisHandler].concat(_toConsumableArray(getAtlaskitAnalyticsEventHandlers()));
  }, [channelRef, onEventRef, getAtlaskitAnalyticsEventHandlers]);
  var value = useMemo(function () {
    return {
      getAtlaskitAnalyticsContext: getAtlaskitAnalyticsContext,
      getAtlaskitAnalyticsEventHandlers: getAnalyticsEventHandlers
    };
  }, [getAtlaskitAnalyticsContext, getAnalyticsEventHandlers]);
  return /*#__PURE__*/React.createElement(AnalyticsReactContext.Provider, {
    value: value
  }, children);
};
export default AnalyticsListener;