"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProjectIndexFiles = void 0;
const project_targets_1 = require("./project-targets");
/** Gets the path of the index file in the given project. */
function getProjectIndexFiles(project) {
    const paths = (0, project_targets_1.getTargetsByBuilderName)(project, project_targets_1.defaultTargetBuilders.build)
        .filter(t => t.options?.index)
        .map(t => t.options.index);
    // Use a set to remove duplicate index files referenced in multiple build targets of a project.
    return Array.from(new Set(paths));
}
exports.getProjectIndexFiles = getProjectIndexFiles;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvamVjdC1pbmRleC1maWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vc3JjL2Nkay9zY2hlbWF0aWNzL3V0aWxzL3Byb2plY3QtaW5kZXgtZmlsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7OztHQU1HOzs7QUFJSCx1REFBaUY7QUFFakYsNERBQTREO0FBQzVELFNBQWdCLG9CQUFvQixDQUFDLE9BQTBCO0lBQzdELE1BQU0sS0FBSyxHQUFHLElBQUEseUNBQXVCLEVBQUMsT0FBTyxFQUFFLHVDQUFxQixDQUFDLEtBQUssQ0FBQztTQUN4RSxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQztTQUM3QixHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsT0FBUSxDQUFDLEtBQWEsQ0FBQyxDQUFDO0lBRXRDLCtGQUErRjtJQUMvRixPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztBQUNwQyxDQUFDO0FBUEQsb0RBT0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuaW1wb3J0IHtQYXRofSBmcm9tICdAYW5ndWxhci1kZXZraXQvY29yZSc7XG5pbXBvcnQge1Byb2plY3REZWZpbml0aW9ufSBmcm9tICdAYW5ndWxhci1kZXZraXQvY29yZS9zcmMvd29ya3NwYWNlJztcbmltcG9ydCB7ZGVmYXVsdFRhcmdldEJ1aWxkZXJzLCBnZXRUYXJnZXRzQnlCdWlsZGVyTmFtZX0gZnJvbSAnLi9wcm9qZWN0LXRhcmdldHMnO1xuXG4vKiogR2V0cyB0aGUgcGF0aCBvZiB0aGUgaW5kZXggZmlsZSBpbiB0aGUgZ2l2ZW4gcHJvamVjdC4gKi9cbmV4cG9ydCBmdW5jdGlvbiBnZXRQcm9qZWN0SW5kZXhGaWxlcyhwcm9qZWN0OiBQcm9qZWN0RGVmaW5pdGlvbik6IFBhdGhbXSB7XG4gIGNvbnN0IHBhdGhzID0gZ2V0VGFyZ2V0c0J5QnVpbGRlck5hbWUocHJvamVjdCwgZGVmYXVsdFRhcmdldEJ1aWxkZXJzLmJ1aWxkKVxuICAgIC5maWx0ZXIodCA9PiB0Lm9wdGlvbnM/LmluZGV4KVxuICAgIC5tYXAodCA9PiB0Lm9wdGlvbnMhLmluZGV4IGFzIFBhdGgpO1xuXG4gIC8vIFVzZSBhIHNldCB0byByZW1vdmUgZHVwbGljYXRlIGluZGV4IGZpbGVzIHJlZmVyZW5jZWQgaW4gbXVsdGlwbGUgYnVpbGQgdGFyZ2V0cyBvZiBhIHByb2plY3QuXG4gIHJldHVybiBBcnJheS5mcm9tKG5ldyBTZXQocGF0aHMpKTtcbn1cbiJdfQ==