/*
 * Decompiled with CFR 0.152.
 */
package adql.db.region;

import adql.db.region.CoordSys;
import adql.db.region.DALI;
import adql.db.region.STCS;
import adql.parser.ADQLQueryFactory;
import adql.parser.grammar.ParseException;
import adql.query.operand.ADQLOperand;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.StringConstant;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import java.util.ArrayList;

public class Region {
    public final RegionType type;
    public final CoordSys coordSys;
    public final double[][] coordinates;
    public final double width;
    public final double height;
    public final double radius;
    public final Region[] regions;
    private String stcs = null;
    private String fullStcs = null;
    private GeometryFunction geometry = null;

    public Region(CoordSys coordSys, double[] coordinates) {
        this(coordSys, new double[][]{coordinates});
    }

    public Region(CoordSys coordSys, double[][] coordinates) {
        if (coordinates == null || coordinates.length == 0) {
            throw new NullPointerException("Missing coordinates!");
        }
        if (coordinates[0].length != 2) {
            throw new IllegalArgumentException("Wrong number of coordinates! Expected at least 2 pairs of coordinates (so coordinates[0], coordinates[1] and coordinates[n].length = 2).");
        }
        this.type = coordinates.length > 1 ? RegionType.POLYGON : RegionType.POSITION;
        this.coordSys = coordSys == null ? new CoordSys() : coordSys;
        this.coordinates = coordinates;
        this.width = Double.NaN;
        this.height = Double.NaN;
        this.radius = Double.NaN;
        this.regions = null;
    }

    public Region(CoordSys coordSys, double[] coordinates, double radius) {
        if (coordinates == null || coordinates.length == 0) {
            throw new NullPointerException("Missing coordinates!");
        }
        if (coordinates.length != 2) {
            throw new IllegalArgumentException("Wrong number of coordinates! Expected exactly 2 values.");
        }
        this.type = RegionType.CIRCLE;
        this.coordSys = coordSys == null ? new CoordSys() : coordSys;
        this.coordinates = new double[][]{coordinates};
        this.radius = radius;
        this.width = Double.NaN;
        this.height = Double.NaN;
        this.regions = null;
    }

    public Region(CoordSys coordSys, double[] coordinates, double width, double height) {
        if (coordinates == null || coordinates.length == 0) {
            throw new NullPointerException("Missing coordinates!");
        }
        if (coordinates.length != 2) {
            throw new IllegalArgumentException("Wrong number of coordinates! Expected exactly 2 values.");
        }
        this.type = RegionType.BOX;
        this.coordSys = coordSys == null ? new CoordSys() : coordSys;
        this.coordinates = new double[][]{coordinates};
        this.width = width;
        this.height = height;
        this.radius = Double.NaN;
        this.regions = null;
    }

    public Region(RegionType unionOrIntersection, CoordSys coordSys, Region[] regions) {
        if (unionOrIntersection == null) {
            throw new NullPointerException("Missing type of region (UNION or INTERSECTION here)!");
        }
        if (unionOrIntersection != RegionType.UNION && unionOrIntersection != RegionType.INTERSECTION) {
            throw new IllegalArgumentException("Wrong region type: \"" + (Object)((Object)unionOrIntersection) + "\"! This constructor lets create only an UNION or INTERSECTION region.");
        }
        if (regions == null || regions.length == 0) {
            throw new NullPointerException("Missing regions to " + (unionOrIntersection == RegionType.UNION ? "unite" : "intersect") + "!");
        }
        if (regions.length < 2) {
            throw new IllegalArgumentException("Wrong number of regions! Expected at least 2 regions.");
        }
        this.type = unionOrIntersection;
        this.coordSys = coordSys == null ? new CoordSys() : coordSys;
        this.regions = regions;
        this.coordinates = null;
        this.radius = Double.NaN;
        this.width = Double.NaN;
        this.height = Double.NaN;
    }

    public Region(Region region) {
        if (region == null) {
            throw new NullPointerException("Missing region to NOT select!");
        }
        this.type = RegionType.NOT;
        this.regions = new Region[]{region};
        this.coordSys = null;
        this.coordinates = null;
        this.radius = Double.NaN;
        this.width = Double.NaN;
        this.height = Double.NaN;
    }

    public Region(GeometryFunction geometry) throws IllegalArgumentException, ParseException {
        if (geometry == null) {
            throw new NullPointerException("Missing geometry to convert into STCS.Region!");
        }
        if (geometry instanceof PointFunction) {
            this.type = RegionType.POSITION;
            this.coordSys = STCS.parseCoordSys(Region.extractString(geometry.getCoordinateSystem()));
            this.coordinates = new double[][]{{Region.extractNumeric(((PointFunction)geometry).getCoord1()), Region.extractNumeric(((PointFunction)geometry).getCoord2())}};
            this.width = Double.NaN;
            this.height = Double.NaN;
            this.radius = Double.NaN;
            this.regions = null;
        } else if (geometry instanceof CircleFunction) {
            this.type = RegionType.CIRCLE;
            this.coordSys = STCS.parseCoordSys(Region.extractString(geometry.getCoordinateSystem()));
            this.coordinates = new double[][]{{Region.extractNumeric(((CircleFunction)geometry).getCoord1()), Region.extractNumeric(((CircleFunction)geometry).getCoord2())}};
            this.radius = Region.extractNumeric(((CircleFunction)geometry).getRadius());
            this.width = Double.NaN;
            this.height = Double.NaN;
            this.regions = null;
        } else if (geometry instanceof BoxFunction) {
            this.type = RegionType.BOX;
            this.coordSys = STCS.parseCoordSys(Region.extractString(geometry.getCoordinateSystem()));
            this.coordinates = new double[][]{{Region.extractNumeric(((BoxFunction)geometry).getCoord1()), Region.extractNumeric(((BoxFunction)geometry).getCoord2())}};
            this.width = Region.extractNumeric(((BoxFunction)geometry).getWidth());
            this.height = Region.extractNumeric(((BoxFunction)geometry).getHeight());
            this.radius = Double.NaN;
            this.regions = null;
        } else if (geometry instanceof PolygonFunction) {
            PolygonFunction poly = (PolygonFunction)geometry;
            this.type = RegionType.POLYGON;
            this.coordSys = STCS.parseCoordSys(Region.extractString(poly.getCoordinateSystem()));
            this.coordinates = new double[(poly.getNbParameters() - 1) / 2][2];
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = new double[]{Region.extractNumeric(poly.getParameter(1 + i * 2)), Region.extractNumeric(poly.getParameter(2 + i * 2))};
            }
            this.width = Double.NaN;
            this.height = Double.NaN;
            this.radius = Double.NaN;
            this.regions = null;
        } else if (geometry instanceof RegionFunction) {
            Region r = Region.parse(Region.extractString(((RegionFunction)geometry).getParameter(0)));
            this.type = r.type;
            this.coordSys = r.coordSys;
            this.coordinates = r.coordinates;
            this.width = r.width;
            this.height = r.height;
            this.radius = r.radius;
            this.regions = r.regions;
        } else {
            throw new IllegalArgumentException("Unknown region type! Only geometrical function PointFunction, CircleFunction, BoxFunction, PolygonFunction and RegionFunction are allowed.");
        }
    }

    private static String extractString(ADQLOperand op) throws ParseException {
        if (op == null) {
            throw new NullPointerException("Missing operand!");
        }
        if (op instanceof StringConstant) {
            return ((StringConstant)op).getValue();
        }
        throw new ParseException("Can not convert into STC-S a non string argument (including ADQLColumn and Concatenation)!");
    }

    private static double extractNumeric(ADQLOperand op) throws ParseException {
        if (op == null) {
            throw new NullPointerException("Missing operand!");
        }
        if (op instanceof NumericConstant) {
            return Double.parseDouble(((NumericConstant)op).getValue());
        }
        if (op instanceof NegativeOperand) {
            return Region.extractNumeric(((NegativeOperand)op).getOperand()) * -1.0;
        }
        throw new ParseException("Can not convert into STC-S a non numeric argument (including ADQLColumn and Operation)!");
    }

    public static Region parse(String strRegion) throws ParseException {
        Region region = null;
        try {
            region = DALI.parseRegion(strRegion);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (region == null) {
            try {
                region = STCS.parseRegion(strRegion);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (region == null) {
            throw new ParseException("Unsupported region serialization!");
        }
        return region;
    }

    public String toDALI() {
        return DALI.toDALI(this);
    }

    public String toSTCS() {
        if (this.stcs != null) {
            return this.stcs;
        }
        this.stcs = STCS.toSTCS(this);
        return this.stcs;
    }

    public String toFullSTCS() {
        if (this.fullStcs != null) {
            return this.fullStcs;
        }
        this.fullStcs = STCS.toSTCS(this, true);
        return this.fullStcs;
    }

    public String toString() {
        String str = this.toDALI();
        if (str == null || this.coordSys != null && !this.coordSys.isDefault()) {
            str = this.toSTCS();
        }
        return str;
    }

    public GeometryFunction toGeometry() {
        return this.toGeometry(null);
    }

    public GeometryFunction toGeometry(ADQLQueryFactory factory) {
        if (factory == null) {
            factory = new ADQLQueryFactory();
        }
        try {
            if (this.geometry != null) {
                return this.geometry;
            }
            StringConstant coordSysObj = factory.createStringConstant(this.coordSys == null ? "" : this.coordSys.toString());
            switch (this.type) {
                case POSITION: {
                    this.geometry = factory.createPoint(coordSysObj, this.toNumericObj(this.coordinates[0][0], factory), this.toNumericObj(this.coordinates[0][1], factory));
                    return this.geometry;
                }
                case CIRCLE: {
                    this.geometry = factory.createCircle(coordSysObj, this.toNumericObj(this.coordinates[0][0], factory), this.toNumericObj(this.coordinates[0][1], factory), this.toNumericObj(this.radius, factory));
                    return this.geometry;
                }
                case BOX: {
                    this.geometry = factory.createBox(coordSysObj, this.toNumericObj(this.coordinates[0][0], factory), this.toNumericObj(this.coordinates[0][1], factory), this.toNumericObj(this.width, factory), this.toNumericObj(this.height, factory));
                    return this.geometry;
                }
                case POLYGON: {
                    ArrayList<ADQLOperand> coords = new ArrayList<ADQLOperand>(this.coordinates.length * 2);
                    for (int i = 0; i < this.coordinates.length; ++i) {
                        coords.add(this.toNumericObj(this.coordinates[i][0], factory));
                        coords.add(this.toNumericObj(this.coordinates[i][1], factory));
                    }
                    this.geometry = factory.createPolygon(coordSysObj, coords);
                    return this.geometry;
                }
            }
            this.geometry = factory.createRegion(factory.createStringConstant(this.toSTCS()));
            return this.geometry;
        }
        catch (Exception pe) {
            return null;
        }
    }

    private ADQLOperand toNumericObj(double val, ADQLQueryFactory factory) throws Exception {
        if (val >= 0.0) {
            return factory.createNumericConstant("" + val);
        }
        return factory.createNegativeOperand(factory.createNumericConstant("" + val * -1.0));
    }

    public static enum RegionType {
        POSITION,
        CIRCLE,
        BOX,
        POLYGON,
        UNION,
        INTERSECTION,
        NOT;

    }
}

