% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-version.R
\name{install_version}
\alias{install_version}
\title{Install specific version of a package.}
\usage{
install_version(
  package,
  version = NULL,
  dependencies = NA,
  upgrade = c("default", "ask", "always", "never"),
  force = FALSE,
  quiet = FALSE,
  build = FALSE,
  build_opts = c("--no-resave-data", "--no-manual", "--no-build-vignettes"),
  build_manual = FALSE,
  build_vignettes = FALSE,
  repos = getOption("repos"),
  type = "source",
  ...
)
}
\arguments{
\item{package}{Name of the package to install.}

\item{version}{Version of the package to install.  Can either be a string giving the exact
version required, or a specification in the same format as the parenthesized expressions used
in package dependencies. One of the following formats:
\itemize{
\item An exact version required, as a string, e.g. \code{"0.1.13"}
\item A comparison operator and a version, e.g. \code{">= 0.1.12"}
\item Several criteria to satisfy, as a comma-separated string, e.g. \code{">= 1.12.0, < 1.14"}
\item Several criteria to satisfy, as elements of a character vector, e.g. \code{c(">= 1.12.0", "< 1.14")}
}}

\item{dependencies}{logical indicating whether to also install
    uninstalled packages which these packages depend on/link
    to/import/suggest (and so on recursively).
    Not used if \code{repos = NULL}.
    Can also be a character vector, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.

    Only supported if \code{lib} is of length one (or missing),
    so it is unambiguous where to install the dependent packages.  If
    this is not the case it is ignored, with a warning.

    The default, \code{NA}, means
    \code{c("Depends", "Imports", "LinkingTo")}.

    \code{TRUE} means to use
    \code{c("Depends", "Imports", "LinkingTo", "Suggests")} for
    \code{pkgs} and
    \code{c("Depends", "Imports", "LinkingTo")} for added dependencies:
    this installs all the packages needed to run \code{pkgs}, their
    examples, tests and vignettes (if the package author specified them
    correctly).

    In all of these, \code{"LinkingTo"} is omitted for binary packages.
  }

\item{upgrade}{Should package dependencies be upgraded? One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{force}{Force installation, even if the remote state has not changed
since the previous install.}

\item{quiet}{
    logical: if true, reduce the amount of output.  This is \emph{not}
    passed to \code{\link[utils]{available.packages}()} in case that is called, on
    purpose.
  }

\item{build}{If \code{TRUE} build the package before installing.}

\item{build_opts}{Options to pass to \verb{R CMD build}, only used when \code{build} is \code{TRUE}.}

\item{build_manual}{If \code{FALSE}, don't build PDF manual ('--no-manual').}

\item{build_vignettes}{If \code{FALSE}, don't build package vignettes ('--no-build-vignettes').}

\item{repos}{
    character vector, the base URL(s) of the repositories
    to use, e.g., the URL of a CRAN mirror such as
    \code{"https://cloud.r-project.org"}.  For more details on
    supported URL schemes see \code{\link{url}}.

    Can be \code{NULL} to install from local files, directories or URLs:
    this will be inferred by extension from \code{pkgs} if of length one.
  }

\item{type}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some macOS
    builds: see the section on \sQuote{Binary packages} for those.
  }

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
This function knows how to look in multiple CRAN-like package repositories, and in their
\code{archive} directories, in order to find specific versions of the requested package.
}
\details{
The repositories are searched in the order specified by the \code{repos} argument.  This enables
teams to maintain multiple in-house repositories with different policies - for instance, one repo
for development snapshots and one for official releases.  A common setup would be to first search
the official release repo, then the dev snapshot repo, then a public CRAN mirror.

Older versions of packages on CRAN are usually only available in source form.  If your requested
package contains compiled code, you will need to have an R development environment installed. You
can check if you do by running \code{devtools::has_devel} (you need the \code{devtools} package for this).
}
\examples{
\dontrun{
install_version("devtools", "1.11.0")
install_version("devtools", ">= 1.12.0, < 1.14")

## Specify search order (e.g. in ~/.Rprofile)
options(repos = c(
  prod = "http://mycompany.example.com/r-repo",
  dev = "http://mycompany.example.com/r-repo-dev",
  CRAN = "https://cran.revolutionanalytics.com"
))
install_version("mypackage", "1.15") # finds in 'prod'
install_version("mypackage", "1.16-39487") # finds in 'dev'
}
}
\seealso{
Other package installation: 
\code{\link{install_bioc}()},
\code{\link{install_bitbucket}()},
\code{\link{install_cran}()},
\code{\link{install_dev}()},
\code{\link{install_github}()},
\code{\link{install_gitlab}()},
\code{\link{install_git}()},
\code{\link{install_local}()},
\code{\link{install_svn}()},
\code{\link{install_url}()}
}
\concept{package installation}
