% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promise.R
\name{promise_resolve}
\alias{promise_resolve}
\alias{promise_reject}
\title{Create a resolved or rejected promise}
\usage{
promise_resolve(value)

promise_reject(reason)
}
\arguments{
\item{value}{A value, or promise, that the new promise should be resolved to.
This expression will be lazily evaluated, and if evaluating the expression
raises an error, then the new promise will be rejected with that error as
the reason.}

\item{reason}{An error message string, or error object.}
}
\description{
Helper functions to conveniently create a promise that is resolved to the
given value (or rejected with the given reason).
}
\examples{
promise_resolve(mtcars) \%...>\%
  head() \%...>\%
  print()

promise_reject("Something went wrong") \%...T!\%
  { message(conditionMessage(.)) }

}
