# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._configuration import LogsIngestionClientConfiguration
from .._utils.model_base import SdkJSONEncoder
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_logs_ingestion_upload_request(
    rule_id: str, stream_name: str, *, content_encoding: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/dataCollectionRules/{ruleId}/streams/{stream}"
    path_format_arguments = {
        "ruleId": _SERIALIZER.url("rule_id", rule_id, "str"),
        "stream": _SERIALIZER.url("stream_name", stream_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_encoding is not None:
        _headers["Content-Encoding"] = _SERIALIZER.header("content_encoding", content_encoding, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class LogsIngestionClientOperationsMixin(
    ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], LogsIngestionClientConfiguration]
):

    @overload
    def _upload(
        self,
        rule_id: str,
        stream_name: str,
        body: List[Dict[str, Any]],
        *,
        content_encoding: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...
    @overload
    def _upload(
        self,
        rule_id: str,
        stream_name: str,
        body: IO[bytes],
        *,
        content_encoding: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...

    @distributed_trace
    def _upload(  # pylint: disable=inconsistent-return-statements
        self,
        rule_id: str,
        stream_name: str,
        body: Union[List[Dict[str, Any]], IO[bytes]],
        *,
        content_encoding: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Ingestion API used to directly ingest data using Data Collection Rules.

        Ingestion API used to directly ingest data using Data Collection Rules.

        :param rule_id: The immutable ID of the Data Collection Rule resource. Required.
        :type rule_id: str
        :param stream_name: The streamDeclaration name as defined in the Data Collection Rule.
         Required.
        :type stream_name: str
        :param body: The array of objects matching the schema defined by the provided stream. Is either
         a [{str: Any}] type or a IO[bytes] type. Required.
        :type body: list[dict[str, any]] or IO[bytes]
        :keyword content_encoding: The content encoding of the request body which is always 'gzip'.
         Default value is None.
        :paramtype content_encoding: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_logs_ingestion_upload_request(
            rule_id=rule_id,
            stream_name=stream_name,
            content_encoding=content_encoding,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
