Author: Andreas Beckmann <anbe@debian.org>
Description: fix LLVMSPIRVOpts.h/LLVMSPIRVExtensions.inc inclusion

--- a/options.h
+++ b/options.h
@@ -21,7 +21,11 @@ Copyright (c) Intel Corporation (2009-20
 #ifndef COMMON_CLANG_OPTIONS_H
 #define COMMON_CLANG_OPTIONS_H
 
+#ifdef USE_PREBUILT_LLVM
+#include "LLVMSPIRVLib/LLVMSPIRVOpts.h"
+#else // USE_PREBUILT_LLVM
 #include "LLVMSPIRVOpts.h"
+#endif // USE_PREBUILT_LLVM
 #include "clang/Basic/OpenCLOptions.h"
 #include "llvm/ADT/ArrayRef.h"
 #include "llvm/ADT/StringRef.h"
--- a/options_compile.cpp
+++ b/options_compile.cpp
@@ -67,7 +67,11 @@ static int parseSPVExtOption(
 #define _STRINGIFY(X) #X
 #define STRINGIFY(X) _STRINGIFY(X)
 #define EXT(X) ExtensionNamesMap[STRINGIFY(X)] = SPIRV::ExtensionID::X;
+#ifdef USE_PREBUILT_LLVM
+#include "LLVMSPIRVLib/LLVMSPIRVExtensions.inc"
+#else // USE_PREBUILT_LLVM
 #include "LLVMSPIRVExtensions.inc"
+#endif // USE_PREBUILT_LLVM
 #undef EXT
 #undef STRINGIFY
 #undef _STRINGIFY
