/**
 * @file
 * Email Address Handling
 *
 * @authors
 * Copyright (C) 2019 Richard Russon <rich@flatcap.org>
 *
 * @copyright
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @page lib_address Address
 *
 * Email Address Handling
 *
 * | File                   | Description               |
 * | :--------------------- | :------------------------ |
 * | address/address.c      | @subpage addr_address     |
 * | address/config_type.c  | @subpage addr_config_type |
 * | address/group.c        | @subpage addr_group       |
 * | address/idna.c         | @subpage addr_idna        |
 */

#ifndef MUTT_ADDRESS_LIB_H
#define MUTT_ADDRESS_LIB_H

// IWYU pragma: begin_keep
#include "address.h"
#include "config_type.h"
#include "group.h"
#include "idna2.h"
// IWYU pragma: end_keep

#endif /* MUTT_ADDRESS_LIB_H */
