/*************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/
#ifdef MBX_FIPS_MODE

#include <crypto_mb/fips_cert.h>
#include <internal/fips_cert/common.h>
#include <internal/rsa/ifma_rsa_method.h>

#include <crypto_mb/rsa.h>

/* KAT TEST (generated via internal tests) */
/* plaintext */
static const int8u plaintext[MBX_RSA2K_DATA_BYTE_LEN] = {
    0x7c, 0x79, 0x2d, 0xc8, 0xfb, 0x14, 0x69, 0x62, 0x7c, 0xcc, 0xfd, 0xc3, 0xde, 0x0b, 0xc1, 0x16,
    0x8e, 0xca, 0xe8, 0x6f, 0x93, 0x3f, 0xbc, 0x7c, 0x0a, 0xd4, 0x46, 0xd8, 0x15, 0xbd, 0x9e, 0xe1,
    0x06, 0x28, 0x35, 0x49, 0x63, 0xac, 0x38, 0x76, 0xf1, 0x3c, 0x68, 0xfb, 0x42, 0x1e, 0x33, 0xf9,
    0x9f, 0x53, 0xe6, 0xd6, 0x33, 0x90, 0x55, 0xbe, 0xc7, 0x05, 0xc8, 0xed, 0xa5, 0x4b, 0xa3, 0x83,
    0xb9, 0x78, 0x19, 0x55, 0xd0, 0x03, 0x0a, 0xad, 0x3c, 0xc3, 0x44, 0x03, 0xf0, 0x27, 0x25, 0xe4,
    0xb8, 0xe0, 0x59, 0xf9, 0xda, 0xb5, 0xeb, 0x9f, 0x5d, 0x63, 0xb6, 0x21, 0xfc, 0x29, 0xe2, 0xa9,
    0xf3, 0x8e, 0x7b, 0xb1, 0x36, 0xf8, 0xb9, 0x67, 0x91, 0x14, 0xef, 0x75, 0xeb, 0x95, 0x37, 0xd3,
    0x03, 0x5f, 0x94, 0x61, 0xc6, 0x42, 0xe1, 0x8a, 0x36, 0x36, 0xb3, 0xe4, 0x3f, 0x99, 0x97, 0x68,
    0x75, 0x85, 0x9a, 0xb9, 0xd8, 0x3c, 0xa4, 0x80, 0xa4, 0xdf, 0xe5, 0x16, 0xfb, 0x00, 0x2c, 0x18,
    0x6b, 0xa4, 0x91, 0x7d, 0x6e, 0x32, 0xca, 0xdb, 0xd1, 0xb5, 0xae, 0x78, 0x1d, 0x46, 0x87, 0xaf,
    0xb9, 0x10, 0x8c, 0x8a, 0x3b, 0x09, 0x59, 0x43, 0x92, 0x39, 0xec, 0x01, 0xe0, 0xb8, 0x9e, 0xad,
    0x30, 0x5b, 0x0e, 0x0d, 0x62, 0x1a, 0xdb, 0xdb, 0xdf, 0xcd, 0x05, 0x19, 0x41, 0x77, 0xc7, 0xf8,
    0xd8, 0x0c, 0x41, 0x57, 0x67, 0xa2, 0x0a, 0x56, 0x67, 0x77, 0x04, 0x5f, 0xfd, 0xc4, 0x7b, 0x0d,
    0x41, 0x22, 0xdc, 0x50, 0x11, 0x3b, 0x0e, 0xe1, 0x6a, 0x91, 0x1e, 0x5f, 0x4c, 0x01, 0xf1, 0xec,
    0x8a, 0x66, 0x1b, 0xf6, 0xd3, 0xbe, 0xc9, 0x98, 0xad, 0xa8, 0x36, 0x62, 0xca, 0x00, 0xcb, 0x76,
    0xa4, 0xb8, 0xb4, 0x94, 0x3c, 0x60, 0xc8, 0xdf, 0xc9, 0x6a, 0xcd, 0x9b, 0x7d, 0xb7, 0x55, 0x73
};
/* ciphertext */
static const int8u ciphertext[MBX_RSA2K_DATA_BYTE_LEN] = {
    0x8a, 0x9b, 0xf5, 0xc2, 0x9f, 0xda, 0x1b, 0x63, 0xd9, 0x01, 0xae, 0x44, 0xf5, 0x7e, 0x2c, 0xec,
    0xf4, 0x5e, 0x3a, 0x02, 0x20, 0x43, 0x39, 0xd4, 0x87, 0xed, 0x46, 0x8e, 0xc0, 0x02, 0x74, 0x77,
    0x5e, 0x5e, 0xaf, 0xcd, 0xe4, 0x3a, 0x70, 0xd4, 0xc7, 0x47, 0x9b, 0xc3, 0x9d, 0x23, 0x72, 0xc7,
    0x7c, 0x0a, 0x00, 0xc9, 0xa8, 0xc8, 0xe4, 0x4c, 0xd2, 0x0f, 0x26, 0xd3, 0x3f, 0x03, 0x87, 0xbc,
    0x8b, 0xf8, 0xe6, 0x6c, 0x9e, 0xe8, 0x18, 0x88, 0xfc, 0xd2, 0x1f, 0x31, 0xda, 0xd6, 0x09, 0x63,
    0x02, 0xa9, 0xf2, 0x8c, 0x3b, 0x77, 0x3f, 0x2c, 0xdc, 0x1a, 0x29, 0xb1, 0x06, 0xb8, 0xbf, 0x98,
    0x25, 0xcd, 0x70, 0xd9, 0x9d, 0xf1, 0xc2, 0x19, 0x8b, 0x65, 0x3e, 0xce, 0x49, 0x25, 0x4e, 0x9f,
    0x23, 0x41, 0x28, 0x8e, 0x90, 0x46, 0x91, 0x2a, 0xae, 0xe2, 0xd2, 0x5c, 0x46, 0x28, 0x87, 0x94,
    0x56, 0xca, 0x13, 0x55, 0x92, 0xb4, 0x7e, 0x3a, 0x0e, 0xe4, 0x28, 0xf8, 0xd4, 0xa8, 0x86, 0x47,
    0x29, 0xc0, 0xdc, 0xdc, 0xc6, 0x98, 0xb4, 0x29, 0x3e, 0x9b, 0x51, 0x97, 0x13, 0x11, 0xac, 0x4d,
    0x21, 0x50, 0x30, 0xe8, 0x44, 0xcf, 0xef, 0x87, 0x91, 0xba, 0x93, 0x2e, 0x2d, 0xde, 0xb5, 0x87,
    0x42, 0x76, 0x8f, 0x66, 0x74, 0xf0, 0xa8, 0x0f, 0x6b, 0x37, 0x74, 0x91, 0x82, 0x78, 0x8a, 0x41,
    0x31, 0x29, 0x5d, 0x0d, 0x4f, 0x31, 0x9f, 0x04, 0x3f, 0xfa, 0x6f, 0x70, 0x25, 0xc3, 0x21, 0x7d,
    0xb6, 0x29, 0x5f, 0x84, 0x8e, 0xc3, 0x12, 0x7c, 0xe6, 0x8b, 0xbd, 0xf7, 0x85, 0x82, 0x26, 0xd8,
    0x46, 0x89, 0xdb, 0xa7, 0x5e, 0xd8, 0x1d, 0x8a, 0xd8, 0x17, 0xcd, 0x9c, 0x62, 0xf5, 0x0c, 0x1b,
    0xa0, 0x49, 0xe9, 0x19, 0x81, 0xaf, 0x8c, 0x80, 0xaf, 0x8f, 0x8f, 0x57, 0x7f, 0x4e, 0xc9, 0xb7
};
/* p, q primes */
static const int8u p[MBX_RSA2K_DATA_BYTE_LEN / 2] = {
    0x85, 0x4f, 0x39, 0xb5, 0x46, 0x67, 0x8b, 0xb4, 0x23, 0x90, 0xfb, 0x9a, 0x83, 0x3b, 0x17, 0xe1,
    0x37, 0xbf, 0xf7, 0x8f, 0x58, 0x78, 0x18, 0xaf, 0xa5, 0x50, 0xff, 0x92, 0xfb, 0xbe, 0xc3, 0x55,
    0x6f, 0x68, 0xa3, 0xb4, 0xd0, 0x2f, 0x05, 0x10, 0x06, 0x16, 0x53, 0x28, 0xe6, 0x08, 0x39, 0x2b,
    0x7d, 0x92, 0xbe, 0xc2, 0x9a, 0x36, 0x74, 0x37, 0x12, 0x19, 0x50, 0x79, 0x82, 0x31, 0xa8, 0x88,
    0xed, 0xe7, 0x7f, 0x6e, 0xe9, 0xcc, 0x80, 0xf1, 0x12, 0xc8, 0xbc, 0xbd, 0xaa, 0x2e, 0xad, 0xe9,
    0x7b, 0x1e, 0x16, 0xb4, 0x60, 0xa3, 0xd0, 0x40, 0x1f, 0x1f, 0x62, 0x7c, 0x60, 0x34, 0xc2, 0xda,
    0x9f, 0x63, 0x7a, 0x41, 0x62, 0xd9, 0x4c, 0x04, 0xad, 0x93, 0xb4, 0xb4, 0xbd, 0x9b, 0xf8, 0x78,
    0x74, 0x5a, 0x04, 0x24, 0x41, 0xef, 0x7d, 0x28, 0x93, 0x6d, 0xc6, 0x06, 0xb1, 0xd4, 0x59, 0xcb
};
static const int8u q[MBX_RSA2K_DATA_BYTE_LEN / 2] = {
    0xd9, 0x39, 0x2b, 0x02, 0xcb, 0xc5, 0xf9, 0x05, 0x17, 0x4e, 0xa7, 0x82, 0x02, 0x15, 0x84, 0xc1,
    0xd0, 0x9c, 0xfb, 0x63, 0x1d, 0x79, 0x55, 0x14, 0x7e, 0x09, 0x95, 0xf1, 0x54, 0xaf, 0xc8, 0x53,
    0xa6, 0xd6, 0xd2, 0xb8, 0x28, 0x84, 0xcb, 0x11, 0x5c, 0x6b, 0xee, 0x86, 0x89, 0x63, 0x3a, 0x52,
    0x0a, 0x9c, 0xd2, 0xf7, 0x12, 0x48, 0x13, 0xd3, 0xd1, 0x35, 0x05, 0xfa, 0xaf, 0xa6, 0x1d, 0x58,
    0x0d, 0xf5, 0x9d, 0x94, 0xa6, 0x0a, 0xe1, 0x2d, 0x1f, 0x2e, 0x37, 0xca, 0xaf, 0xca, 0x53, 0x72,
    0x1b, 0x5c, 0x86, 0x7b, 0x35, 0x96, 0x5c, 0x86, 0x74, 0xa8, 0xb2, 0x41, 0x9b, 0xce, 0x08, 0xbe,
    0xf4, 0x76, 0xfd, 0x92, 0x9f, 0x12, 0xba, 0xae, 0xe9, 0xee, 0x71, 0x6c, 0x81, 0x1c, 0x96, 0x93,
    0x95, 0xb0, 0xa3, 0xbc, 0xaf, 0xc0, 0x04, 0x0e, 0x04, 0x36, 0xa7, 0xfe, 0xe9, 0xc4, 0x7f, 0xca
};
/* p's, q's CRT private exponent */
static const int8u dp[MBX_RSA2K_DATA_BYTE_LEN / 2] = {
    0xcd, 0x46, 0xe8, 0x8b, 0x54, 0xbf, 0xb2, 0xb8, 0xe0, 0x52, 0x4e, 0xc3, 0xfd, 0xfd, 0x4f, 0xe4,
    0xef, 0x89, 0x60, 0x5f, 0xb1, 0xdc, 0x67, 0x6d, 0x4e, 0x17, 0x34, 0xc1, 0x3f, 0x01, 0x2f, 0xb6,
    0x1e, 0x7a, 0xcc, 0x3f, 0xa0, 0xdd, 0x3d, 0xcf, 0xb5, 0x64, 0x85, 0x63, 0x57, 0xd9, 0xb9, 0xb4,
    0x9d, 0xe6, 0x42, 0x6b, 0x7b, 0x24, 0x43, 0xde, 0x49, 0xb3, 0x01, 0xd0, 0x0c, 0x18, 0x13, 0xd1,
    0x5d, 0xaa, 0xde, 0x86, 0xd0, 0x90, 0xf4, 0x6e, 0x17, 0x31, 0xad, 0x96, 0xc8, 0xe1, 0x71, 0xb2,
    0xa8, 0x2e, 0xd7, 0x41, 0x38, 0xef, 0x94, 0x6f, 0xd0, 0xcd, 0x62, 0xa0, 0x6f, 0x4e, 0xe3, 0x22,
    0x7c, 0x3e, 0xf0, 0x16, 0x7e, 0x41, 0x97, 0x44, 0xa7, 0xe9, 0x97, 0x6d, 0x6d, 0xea, 0x9f, 0x5e,
    0x5c, 0x43, 0x71, 0xd1, 0xc4, 0x0b, 0x02, 0xc4, 0xb5, 0x29, 0x4a, 0xf1, 0x7b, 0x70, 0x1f, 0x13
};
static const int8u dq[MBX_RSA2K_DATA_BYTE_LEN / 2] = {
    0x01, 0xa0, 0x8d, 0x81, 0xf4, 0x12, 0x67, 0x77, 0xff, 0xed, 0x4d, 0x48, 0x51, 0x4e, 0x9b, 0xa6,
    0xbf, 0x46, 0x01, 0xb2, 0x6d, 0x31, 0xf5, 0xd6, 0xce, 0xb5, 0x6a, 0x38, 0x34, 0xb0, 0xe3, 0x58,
    0xbf, 0xa2, 0x8f, 0xc7, 0xc1, 0xc3, 0x37, 0xef, 0xf3, 0xa4, 0x35, 0x3c, 0x6a, 0xff, 0xe9, 0xaf,
    0x5b, 0xbb, 0x36, 0xa1, 0xde, 0xd0, 0x05, 0xb4, 0x72, 0x79, 0x2a, 0xbf, 0x6e, 0x7f, 0xa2, 0x73,
    0x04, 0xad, 0x6a, 0x58, 0x6a, 0xb2, 0x14, 0x0c, 0xac, 0x42, 0x23, 0xac, 0x41, 0x87, 0x3f, 0x1c,
    0x8c, 0x52, 0x0a, 0x2b, 0xe9, 0x5d, 0x4b, 0x55, 0x32, 0xfa, 0x48, 0xe5, 0x1c, 0x7e, 0x4f, 0x92,
    0x3a, 0xca, 0xa6, 0x9d, 0xcc, 0xc8, 0x90, 0xd3, 0x62, 0xf1, 0x9b, 0xc2, 0xce, 0x92, 0xdf, 0x9b,
    0xb7, 0x72, 0xab, 0xea, 0x8a, 0x45, 0x9e, 0xd7, 0xaa, 0x1b, 0xfe, 0x14, 0xb1, 0xc2, 0x75, 0x2f
};
/* CRT coefficient */
static const int8u inv_q[MBX_RSA2K_DATA_BYTE_LEN / 2] = {
    0x59, 0x3e, 0x24, 0x2f, 0xb3, 0xc6, 0x03, 0xbf, 0x1e, 0xb5, 0x5b, 0xea, 0xbf, 0x33, 0x00, 0x66,
    0x2f, 0x9b, 0x6c, 0x65, 0x9e, 0x76, 0x8e, 0x92, 0xb3, 0x52, 0xc3, 0x05, 0x85, 0x87, 0x41, 0x44,
    0x51, 0x10, 0x49, 0xba, 0x2b, 0x37, 0x4a, 0x9a, 0x40, 0x88, 0xf5, 0x2f, 0x44, 0xed, 0x96, 0xfc,
    0xa0, 0xa5, 0x25, 0x58, 0x25, 0xc4, 0xce, 0xce, 0x7f, 0x75, 0xc3, 0x1e, 0xb9, 0x12, 0xc8, 0x65,
    0x5f, 0xc2, 0xaf, 0xfe, 0x8d, 0xde, 0xb6, 0x70, 0x81, 0x09, 0x04, 0xd2, 0xf2, 0x95, 0x11, 0x9c,
    0x3b, 0x56, 0xd3, 0xca, 0x67, 0x73, 0xc9, 0x19, 0x3d, 0x24, 0x33, 0x07, 0x5f, 0x32, 0x94, 0x36,
    0x64, 0x7d, 0xdc, 0x12, 0xcf, 0xd7, 0x17, 0x58, 0xa5, 0x68, 0x94, 0x93, 0x6c, 0x16, 0xd2, 0xec,
    0x98, 0xd5, 0xdc, 0xde, 0xa2, 0xe1, 0x93, 0x7a, 0xb2, 0xff, 0xc9, 0xd1, 0xc5, 0x57, 0x66, 0x92
};

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa2k_private_crt_mb8(void)
{
    fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

    /* output plaintext */
    int8u out_plaintext[MBX_LANES][MBX_RSA2K_DATA_BYTE_LEN];
    /* key operation */
    const mbx_RSA_Method* method = mbx_RSA2K_private_crt_Method();

    /* function input parameters */
    // ciphertext
    const int8u* pa_ciphertext[MBX_LANES] = { ciphertext, ciphertext, ciphertext, ciphertext,
                                              ciphertext, ciphertext, ciphertext, ciphertext };
    // plaintext
    int8u* pa_plaintext[MBX_LANES] = { out_plaintext[0], out_plaintext[1], out_plaintext[2],
                                       out_plaintext[3], out_plaintext[4], out_plaintext[5],
                                       out_plaintext[6], out_plaintext[7] };
    // p, q primes
    const int64u* pa_p[MBX_LANES] = { (int64u*)p, (int64u*)p, (int64u*)p, (int64u*)p,
                                      (int64u*)p, (int64u*)p, (int64u*)p, (int64u*)p };
    const int64u* pa_q[MBX_LANES] = { (int64u*)q, (int64u*)q, (int64u*)q, (int64u*)q,
                                      (int64u*)q, (int64u*)q, (int64u*)q, (int64u*)q };
    /* p's, q's CRT private exponent */
    const int64u* pa_dp[MBX_LANES] = { (int64u*)dp, (int64u*)dp, (int64u*)dp, (int64u*)dp,
                                       (int64u*)dp, (int64u*)dp, (int64u*)dp, (int64u*)dp };
    const int64u* pa_dq[MBX_LANES] = { (int64u*)dq, (int64u*)dq, (int64u*)dq, (int64u*)dq,
                                       (int64u*)dq, (int64u*)dq, (int64u*)dq, (int64u*)dq };
    /* CRT coefficient */
    const int64u* pa_inv_q[MBX_LANES] = { (int64u*)inv_q, (int64u*)inv_q, (int64u*)inv_q,
                                          (int64u*)inv_q, (int64u*)inv_q, (int64u*)inv_q,
                                          (int64u*)inv_q, (int64u*)inv_q };

    /* test function */
    mbx_status sts;
    sts         = mbx_rsa_private_crt_mb8(pa_ciphertext,
                                  pa_plaintext,
                                  pa_p,
                                  pa_q,
                                  pa_dp,
                                  pa_dq,
                                  pa_inv_q,
                                  MBX_RSA2K_DATA_BIT_LEN,
                                  method,
                                  NULL);
    test_result = mbx_selftest_check_if_success(sts, MBX_ALGO_SELFTEST_BAD_ARGS_ERR);

    // compare output plaintext to known answer
    int output_status;
    for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
        output_status = mbx_is_mem_eq(pa_plaintext[i],
                                      MBX_RSA2K_DATA_BYTE_LEN,
                                      plaintext,
                                      MBX_RSA2K_DATA_BYTE_LEN);
        if (!output_status) { // wrong output
            test_result = MBX_ALGO_SELFTEST_KAT_ERR;
        }
    }

    return test_result;
}

#ifndef BN_OPENSSL_DISABLE

// memory free macro
#define MEM_FREE(BN_PTR1, BN_PTR2, BN_PTR3, BN_PTR4, BN_PTR5) \
    {                                                         \
        BN_free(BN_PTR1);                                     \
        BN_free(BN_PTR2);                                     \
        BN_free(BN_PTR3);                                     \
        BN_free(BN_PTR4);                                     \
        BN_free(BN_PTR5);                                     \
    }

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa2k_private_crt_ssl_mb8(void)
{

    fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

    /* output plaintext */
    int8u out_plaintext[MBX_LANES][MBX_RSA2K_DATA_BYTE_LEN];
    /* ssl parameters */
    // p, q primes
    BIGNUM* BN_p = BN_new();
    BIGNUM* BN_q = BN_new();
    // p's, q's CRT private exponent
    BIGNUM* BN_dp = BN_new();
    BIGNUM* BN_dq = BN_new();
    // CRT coefficient
    BIGNUM* BN_inv_q = BN_new();
    /* check if allocated memory is valid */
    if (NULL == BN_p || NULL == BN_q || NULL == BN_dp || NULL == BN_dq || NULL == BN_inv_q) {
        test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
        MEM_FREE(BN_p, BN_q, BN_dp, BN_dq, BN_inv_q)
        return test_result;
    }

    /* set ssl parameters */
    BN_lebin2bn(p, MBX_RSA2K_DATA_BYTE_LEN / 2, BN_p);
    BN_lebin2bn(q, MBX_RSA2K_DATA_BYTE_LEN / 2, BN_q);
    BN_lebin2bn(dp, MBX_RSA2K_DATA_BYTE_LEN / 2, BN_dp);
    BN_lebin2bn(dq, MBX_RSA2K_DATA_BYTE_LEN / 2, BN_dq);
    BN_lebin2bn(inv_q, MBX_RSA2K_DATA_BYTE_LEN / 2, BN_inv_q);

    /* function input parameters */
    // ciphertext
    const int8u* pa_ciphertext[MBX_LANES] = { ciphertext, ciphertext, ciphertext, ciphertext,
                                              ciphertext, ciphertext, ciphertext, ciphertext };
    // plaintext
    int8u* pa_plaintext[MBX_LANES] = { out_plaintext[0], out_plaintext[1], out_plaintext[2],
                                       out_plaintext[3], out_plaintext[4], out_plaintext[5],
                                       out_plaintext[6], out_plaintext[7] };
    // p, q primes
    const BIGNUM* pa_p[MBX_LANES] = { (const BIGNUM*)BN_p, (const BIGNUM*)BN_p, (const BIGNUM*)BN_p,
                                      (const BIGNUM*)BN_p, (const BIGNUM*)BN_p, (const BIGNUM*)BN_p,
                                      (const BIGNUM*)BN_p, (const BIGNUM*)BN_p };
    const BIGNUM* pa_q[MBX_LANES] = { (const BIGNUM*)BN_q, (const BIGNUM*)BN_q, (const BIGNUM*)BN_q,
                                      (const BIGNUM*)BN_q, (const BIGNUM*)BN_q, (const BIGNUM*)BN_q,
                                      (const BIGNUM*)BN_q, (const BIGNUM*)BN_q };
    // p's, q's CRT private exponent
    const BIGNUM* pa_dp[MBX_LANES] = { (const BIGNUM*)BN_dp, (const BIGNUM*)BN_dp,
                                       (const BIGNUM*)BN_dp, (const BIGNUM*)BN_dp,
                                       (const BIGNUM*)BN_dp, (const BIGNUM*)BN_dp,
                                       (const BIGNUM*)BN_dp, (const BIGNUM*)BN_dp };
    const BIGNUM* pa_dq[MBX_LANES] = { (const BIGNUM*)BN_dq, (const BIGNUM*)BN_dq,
                                       (const BIGNUM*)BN_dq, (const BIGNUM*)BN_dq,
                                       (const BIGNUM*)BN_dq, (const BIGNUM*)BN_dq,
                                       (const BIGNUM*)BN_dq, (const BIGNUM*)BN_dq };
    // CRT coefficient
    const BIGNUM* pa_inv_q[MBX_LANES] = { (const BIGNUM*)BN_inv_q, (const BIGNUM*)BN_inv_q,
                                          (const BIGNUM*)BN_inv_q, (const BIGNUM*)BN_inv_q,
                                          (const BIGNUM*)BN_inv_q, (const BIGNUM*)BN_inv_q,
                                          (const BIGNUM*)BN_inv_q, (const BIGNUM*)BN_inv_q };

    /* test function */
    mbx_status sts;
    sts = mbx_rsa_private_crt_ssl_mb8(pa_ciphertext,
                                      pa_plaintext,
                                      pa_p,
                                      pa_q,
                                      pa_dp,
                                      pa_dq,
                                      pa_inv_q,
                                      MBX_RSA2K_DATA_BIT_LEN);

    test_result = mbx_selftest_check_if_success(sts, MBX_ALGO_SELFTEST_BAD_ARGS_ERR);

    // compare output signature to known answer
    int output_status;
    for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
        output_status = mbx_is_mem_eq(pa_plaintext[i],
                                      MBX_RSA2K_DATA_BYTE_LEN,
                                      plaintext,
                                      MBX_RSA2K_DATA_BYTE_LEN);
        if (!output_status) { // wrong output
            test_result = MBX_ALGO_SELFTEST_KAT_ERR;
        }
    }

    // memory free
    MEM_FREE(BN_p, BN_q, BN_dp, BN_dq, BN_inv_q)

    return test_result;
}

#endif // BN_OPENSSL_DISABLE
#endif // MBX_FIPS_MODE
