#pragma once
/*
 *  $Id: arithmetic.h 28862 2025-11-14 13:21:37Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_ARITHMETIC_H__
#define __GWY_ARITHMETIC_H__

#include <libgwyddion/line.h>
#include <libgwyddion/field.h>
#include <libgwyddion/nield.h>
#include <libgwyddion/brick.h>
#include <libgwyddion/lawn.h>

G_BEGIN_DECLS

typedef enum {
    GWY_DATA_MISMATCH_RES      = 1 << 0,
    GWY_DATA_MISMATCH_REAL     = 1 << 1,
    GWY_DATA_MISMATCH_MEASURE  = 1 << 2,
    GWY_DATA_MISMATCH_LATERAL  = 1 << 3,
    GWY_DATA_MISMATCH_VALUE    = 1 << 4,
    GWY_DATA_MISMATCH_AXISCAL  = 1 << 5,
    GWY_DATA_MISMATCH_NCURVES  = 1 << 6,
    GWY_DATA_MISMATCH_CURVELEN = 1 << 7,
    GWY_DATA_MISMATCH_ALL      = 0x00ff
} GwyDataMismatchFlags;

void                 gwy_line_sum_lines                     (GwyLine *result,
                                                             GwyLine *operand1,
                                                             GwyLine *operand2);
void                 gwy_line_subtract_lines                (GwyLine *result,
                                                             GwyLine *operand1,
                                                             GwyLine *operand2);
void                 gwy_line_multiply_lines                (GwyLine *result,
                                                             GwyLine *operand1,
                                                             GwyLine *operand2);
void                 gwy_line_linear_combination            (GwyLine *result,
                                                             gdouble coeff1,
                                                             GwyLine *operand1,
                                                             gdouble coeff2,
                                                             GwyLine *operand2,
                                                             gdouble constant);
void                 gwy_field_sum_fields                   (GwyField *result,
                                                             GwyField *operand1,
                                                             GwyField *operand2);
void                 gwy_field_subtract_fields              (GwyField *result,
                                                             GwyField *operand1,
                                                             GwyField *operand2);
void                 gwy_field_divide_fields                (GwyField *result,
                                                             GwyField *operand1,
                                                             GwyField *operand2);
void                 gwy_field_multiply_fields              (GwyField *result,
                                                             GwyField *operand1,
                                                             GwyField *operand2);
void                 gwy_field_min_of_fields                (GwyField *result,
                                                             GwyField *operand1,
                                                             GwyField *operand2);
void                 gwy_field_max_of_fields                (GwyField *result,
                                                             GwyField *operand1,
                                                             GwyField *operand2);
void                 gwy_field_hypot_of_fields              (GwyField *result,
                                                             GwyField *operand1,
                                                             GwyField *operand2);
void                 gwy_field_linear_combination           (GwyField *result,
                                                             gdouble coeff1,
                                                             GwyField *operand1,
                                                             gdouble coeff2,
                                                             GwyField *operand2,
                                                             gdouble constant);
GwyDataMismatchFlags gwy_line_is_incompatible               (GwyLine *line1,
                                                             GwyLine *line2,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_field_is_incompatible              (GwyField *field1,
                                                             GwyField *field2,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_nield_is_incompatible              (GwyNield *nield1,
                                                             GwyNield *nield2,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_brick_is_incompatible              (GwyBrick *brick1,
                                                             GwyBrick *brick2,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_lawn_is_incompatible               (GwyLawn *lawn1,
                                                             GwyLawn *lawn2,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_field_is_incompatible_with_brick_xy(GwyField *field,
                                                             GwyBrick *brick,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_line_is_incompatible_with_brick_z  (GwyLine *line,
                                                             GwyBrick *brick,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_field_is_incompatible_with_lawn    (GwyField *field,
                                                             GwyLawn *lawn,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_nield_is_incompatible_with_field   (GwyNield *nield,
                                                             GwyField *field,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_nield_is_incompatible_with_brick_xy(GwyNield *nield,
                                                             GwyBrick *brick,
                                                             GwyDataMismatchFlags check);
GwyDataMismatchFlags gwy_nield_is_incompatible_with_lawn    (GwyNield *nield,
                                                             GwyLawn *lawn,
                                                             GwyDataMismatchFlags check);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
