//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armwindowsesu

import "time"

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition

	// READ-ONLY; Description of the error.
	Message *string
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition
}

// MultipleActivationKey - MAK key details.
type MultipleActivationKey struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// MAK key specific properties.
	Properties *MultipleActivationKeyProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MultipleActivationKeyList - List of MAK keys.
type MultipleActivationKeyList struct {
	// List of MAK keys.
	Value []*MultipleActivationKey

	// READ-ONLY; Link to the next page of resources.
	NextLink *string
}

// MultipleActivationKeyProperties - MAK key specific properties.
type MultipleActivationKeyProperties struct {
	// Agreement number under which the key is requested.
	AgreementNumber *string

	// Number of activations/servers using the MAK key.
	InstalledServerNumber *int32

	// true if user has eligible on-premises Windows physical or virtual machines, and that the requested key will only be used
	// in their organization; false otherwise.
	IsEligible *bool

	// Type of OS for which the key is requested.
	OSType *OsType

	// Type of support
	SupportType *SupportType

	// READ-ONLY; End of support of security updates activated by the MAK key.
	ExpirationDate *time.Time

	// READ-ONLY; MAK 5x5 key.
	MultipleActivationKey *string

	// READ-ONLY
	ProvisioningState *ProvisioningState
}

// MultipleActivationKeyUpdate - MAK key details.
type MultipleActivationKeyUpdate struct {
	// Resource tags.
	Tags map[string]*string
}

// Operation - REST API operation details.
type Operation struct {
	// Meta data about operation used for display in portal.
	Display *OperationDisplay

	// READ-ONLY; Name of the operation.
	Name *string
}

// OperationDisplay - Meta data about operation used for display in portal.
type OperationDisplay struct {
	Description *string
	Operation   *string
	Provider    *string
	Resource    *string
}

// OperationList - List of available REST API operations.
type OperationList struct {
	// List of operations.
	Value []*Operation

	// READ-ONLY; Link to the next page of resources.
	NextLink *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}
