//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmachinelearning_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/machinelearning/armmachinelearning/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/get.json
func ExampleWorkspacesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Get(ctx, "workspace-1234", "testworkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armmachinelearning.Workspace{
	// 	Name: to.Ptr("testworkspace"),
	// 	Type: to.Ptr("Microsoft.MachineLearningServices/workspaces"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace"),
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testuai": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus2euap"),
	// 	Properties: &armmachinelearning.WorkspaceProperties{
	// 		Description: to.Ptr("test description"),
	// 		AllowPublicAccessWhenBehindVnet: to.Ptr(false),
	// 		ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
	// 		ContainerRegistry: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistry"),
	// 		DiscoveryURL: to.Ptr("http://example.com"),
	// 		Encryption: &armmachinelearning.EncryptionProperty{
	// 			Identity: &armmachinelearning.IdentityForCmk{
	// 				UserAssignedIdentity: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testuai"),
	// 			},
	// 			KeyVaultProperties: &armmachinelearning.EncryptionKeyVaultProperties{
	// 				IdentityClientID: to.Ptr(""),
	// 				KeyIdentifier: to.Ptr("https://testkv.vault.azure.net/keys/testkey/aabbccddee112233445566778899aabb"),
	// 				KeyVaultArmID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
	// 			},
	// 			Status: to.Ptr(armmachinelearning.EncryptionStatusEnabled),
	// 		},
	// 		FriendlyName: to.Ptr("HelloName"),
	// 		HbiWorkspace: to.Ptr(false),
	// 		ImageBuildCompute: to.Ptr("testcompute"),
	// 		KeyVault: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
	// 		PrivateEndpointConnections: []*armmachinelearning.PrivateEndpointConnection{
	// 			{
	// 				Name: to.Ptr("testprivatelinkconnection"),
	// 				Type: to.Ptr("Microsoft.MachineLearningServices/workspaces/privateEndpointConnections"),
	// 				ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace/privateEndpointConnections/testprivatelinkconnection"),
	// 				Properties: &armmachinelearning.PrivateEndpointConnectionProperties{
	// 					PrivateEndpoint: &armmachinelearning.PrivateEndpoint{
	// 						ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg-1234/providers/Microsoft.Network/privateEndpoints/petest01"),
	// 					},
	// 					PrivateLinkServiceConnectionState: &armmachinelearning.PrivateLinkServiceConnectionState{
	// 						Description: to.Ptr("Auto-Approved"),
	// 						ActionsRequired: to.Ptr("None"),
	// 						Status: to.Ptr(armmachinelearning.PrivateEndpointServiceConnectionStatusApproved),
	// 					},
	// 					ProvisioningState: to.Ptr(armmachinelearning.PrivateEndpointConnectionProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		PrivateLinkCount: to.Ptr[int32](0),
	// 		PublicNetworkAccess: to.Ptr(armmachinelearning.PublicNetworkAccessDisabled),
	// 		ServiceProvisionedResourceGroup: to.Ptr("testworkspace_0000111122223333"),
	// 		SharedPrivateLinkResources: []*armmachinelearning.SharedPrivateLinkResource{
	// 			{
	// 				Name: to.Ptr("testcosmosdbresource"),
	// 				Properties: &armmachinelearning.SharedPrivateLinkResourceProperty{
	// 					GroupID: to.Ptr("Sql"),
	// 					PrivateLinkResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.DocumentDB/databaseAccounts/testcosmosdbresource/privateLinkResources/Sql"),
	// 					RequestMessage: to.Ptr("Please approve"),
	// 					Status: to.Ptr(armmachinelearning.PrivateEndpointServiceConnectionStatusApproved),
	// 				},
	// 		}},
	// 		StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/create.json
func ExampleWorkspacesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginCreateOrUpdate(ctx, "workspace-1234", "testworkspace", armmachinelearning.Workspace{
		Identity: &armmachinelearning.ManagedServiceIdentity{
			Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
				"/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testuai": {},
			},
		},
		Location: to.Ptr("eastus2euap"),
		Properties: &armmachinelearning.WorkspaceProperties{
			Description:         to.Ptr("test description"),
			ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
			ContainerRegistry:   to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistry"),
			Encryption: &armmachinelearning.EncryptionProperty{
				Identity: &armmachinelearning.IdentityForCmk{
					UserAssignedIdentity: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testuai"),
				},
				KeyVaultProperties: &armmachinelearning.EncryptionKeyVaultProperties{
					IdentityClientID: to.Ptr(""),
					KeyIdentifier:    to.Ptr("https://testkv.vault.azure.net/keys/testkey/aabbccddee112233445566778899aabb"),
					KeyVaultArmID:    to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
				},
				Status: to.Ptr(armmachinelearning.EncryptionStatusEnabled),
			},
			FriendlyName: to.Ptr("HelloName"),
			HbiWorkspace: to.Ptr(false),
			KeyVault:     to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
			SharedPrivateLinkResources: []*armmachinelearning.SharedPrivateLinkResource{
				{
					Name: to.Ptr("testdbresource"),
					Properties: &armmachinelearning.SharedPrivateLinkResourceProperty{
						GroupID:               to.Ptr("Sql"),
						PrivateLinkResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.DocumentDB/databaseAccounts/testdbresource/privateLinkResources/Sql"),
						RequestMessage:        to.Ptr("Please approve"),
						Status:                to.Ptr(armmachinelearning.PrivateEndpointServiceConnectionStatusApproved),
					},
				}},
			StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armmachinelearning.Workspace{
	// 	Name: to.Ptr("testworkspace"),
	// 	Type: to.Ptr("Microsoft.MachineLearningServices/workspaces"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace"),
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testuai": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("eastus2euap"),
	// 	Properties: &armmachinelearning.WorkspaceProperties{
	// 		Description: to.Ptr("test description"),
	// 		AllowPublicAccessWhenBehindVnet: to.Ptr(false),
	// 		ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
	// 		ContainerRegistry: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistry"),
	// 		DiscoveryURL: to.Ptr("http://example.com"),
	// 		Encryption: &armmachinelearning.EncryptionProperty{
	// 			Identity: &armmachinelearning.IdentityForCmk{
	// 				UserAssignedIdentity: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testuai"),
	// 			},
	// 			KeyVaultProperties: &armmachinelearning.EncryptionKeyVaultProperties{
	// 				IdentityClientID: to.Ptr(""),
	// 				KeyIdentifier: to.Ptr("https://testkv.vault.azure.net/keys/testkey/aabbccddee112233445566778899aabb"),
	// 				KeyVaultArmID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
	// 			},
	// 			Status: to.Ptr(armmachinelearning.EncryptionStatusEnabled),
	// 		},
	// 		FriendlyName: to.Ptr("HelloName"),
	// 		HbiWorkspace: to.Ptr(false),
	// 		KeyVault: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
	// 		PublicNetworkAccess: to.Ptr(armmachinelearning.PublicNetworkAccessDisabled),
	// 		SharedPrivateLinkResources: []*armmachinelearning.SharedPrivateLinkResource{
	// 			{
	// 				Name: to.Ptr("testdbresource"),
	// 				Properties: &armmachinelearning.SharedPrivateLinkResourceProperty{
	// 					GroupID: to.Ptr("Sql"),
	// 					PrivateLinkResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.DocumentDB/databaseAccounts/testdbresource/privateLinkResources/Sql"),
	// 					RequestMessage: to.Ptr("Please approve"),
	// 					Status: to.Ptr(armmachinelearning.PrivateEndpointServiceConnectionStatusApproved),
	// 				},
	// 		}},
	// 		StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/delete.json
func ExampleWorkspacesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginDelete(ctx, "workspace-1234", "testworkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/update.json
func ExampleWorkspacesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginUpdate(ctx, "workspace-1234", "testworkspace", armmachinelearning.WorkspaceUpdateParameters{
		Properties: &armmachinelearning.WorkspacePropertiesUpdateParameters{
			Description:         to.Ptr("new description"),
			FriendlyName:        to.Ptr("New friendly name"),
			PublicNetworkAccess: to.Ptr(armmachinelearning.PublicNetworkAccessDisabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armmachinelearning.Workspace{
	// 	Name: to.Ptr("testworkspace"),
	// 	Type: to.Ptr("Microsoft.MachineLearningServices/workspaces"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace"),
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 	},
	// 	Location: to.Ptr("eastus2euap"),
	// 	Properties: &armmachinelearning.WorkspaceProperties{
	// 		Description: to.Ptr("new description"),
	// 		ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
	// 		ContainerRegistry: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistry"),
	// 		DiscoveryURL: to.Ptr("http://example.com"),
	// 		FriendlyName: to.Ptr("New friendly name"),
	// 		KeyVault: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
	// 		PublicNetworkAccess: to.Ptr(armmachinelearning.PublicNetworkAccessDisabled),
	// 		StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/listByResourceGroup.json
func ExampleWorkspacesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListByResourceGroupPager("workspace-1234", &armmachinelearning.WorkspacesClientListByResourceGroupOptions{Skip: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceListResult = armmachinelearning.WorkspaceListResult{
		// 	Value: []*armmachinelearning.Workspace{
		// 		{
		// 			Name: to.Ptr("testworkspace"),
		// 			Type: to.Ptr("Microsoft.MachineLearningServices/workspaces"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Properties: &armmachinelearning.WorkspaceProperties{
		// 				Description: to.Ptr("test description"),
		// 				ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
		// 				ContainerRegistry: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistry"),
		// 				DiscoveryURL: to.Ptr("http://example.com"),
		// 				FriendlyName: to.Ptr("HelloName"),
		// 				KeyVault: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
		// 				StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testworkspace1"),
		// 			Type: to.Ptr("Microsoft.MachineLearningServices/workspaces"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace1"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Properties: &armmachinelearning.WorkspaceProperties{
		// 				Description: to.Ptr("test description"),
		// 				ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
		// 				ContainerRegistry: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistryNew"),
		// 				DiscoveryURL: to.Ptr("http://example.com"),
		// 				FriendlyName: to.Ptr("HelloName 1"),
		// 				KeyVault: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkvNew"),
		// 				StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccountOld"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/diagnose.json
func ExampleWorkspacesClient_BeginDiagnose() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginDiagnose(ctx, "workspace-1234", "testworkspace", &armmachinelearning.WorkspacesClientBeginDiagnoseOptions{Parameters: &armmachinelearning.DiagnoseWorkspaceParameters{
		Value: &armmachinelearning.DiagnoseRequestProperties{
			ApplicationInsights: map[string]any{},
			ContainerRegistry:   map[string]any{},
			DNSResolution:       map[string]any{},
			KeyVault:            map[string]any{},
			Nsg:                 map[string]any{},
			Others:              map[string]any{},
			ResourceLock:        map[string]any{},
			StorageAccount:      map[string]any{},
			Udr:                 map[string]any{},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DiagnoseResponseResult = armmachinelearning.DiagnoseResponseResult{
	// 	Value: &armmachinelearning.DiagnoseResponseResultValue{
	// 		ApplicationInsightsResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 		ContainerRegistryResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 		DNSResolutionResults: []*armmachinelearning.DiagnoseResult{
	// 			{
	// 				Code: to.Ptr("CustomDNSInUse"),
	// 				Level: to.Ptr(armmachinelearning.DiagnoseResultLevelWarning),
	// 				Message: to.Ptr("We have detected an on-premise dns server is configured. Please make sure conditional forwarding is configured correctly according to doc https://foo"),
	// 		}},
	// 		KeyVaultResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 		NetworkSecurityRuleResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 		OtherResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 		ResourceLockResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 		StorageAccountResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 		UserDefinedRouteResults: []*armmachinelearning.DiagnoseResult{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/listKeys.json
func ExampleWorkspacesClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().ListKeys(ctx, "testrg123", "workspaces123", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListWorkspaceKeysResult = armmachinelearning.ListWorkspaceKeysResult{
	// 	ContainerRegistryCredentials: &armmachinelearning.RegistryListCredentialsResult{
	// 		Passwords: []*armmachinelearning.Password{
	// 			{
	// 				Name: to.Ptr("password"),
	// 				Value: to.Ptr("<value>"),
	// 			},
	// 			{
	// 				Name: to.Ptr("password2"),
	// 				Value: to.Ptr("0KARRQoQHSUq1yViPWg7YFernOS=Ic/t"),
	// 		}},
	// 		Username: to.Ptr("testdemoworkjmjmeykp"),
	// 	},
	// 	NotebookAccessKeys: &armmachinelearning.ListNotebookKeysResult{
	// 	},
	// 	UserStorageResourceID: to.Ptr("/subscriptions/aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee/resourceGroups/ragargeastus2euap/providers/Microsoft.Storage/storageAccounts/testdemoworkazashomr"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/resyncKeys.json
func ExampleWorkspacesClient_BeginResyncKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginResyncKeys(ctx, "testrg123", "workspaces123", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/listBySubscription.json
func ExampleWorkspacesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListBySubscriptionPager(&armmachinelearning.WorkspacesClientListBySubscriptionOptions{Skip: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceListResult = armmachinelearning.WorkspaceListResult{
		// 	Value: []*armmachinelearning.Workspace{
		// 		{
		// 			Name: to.Ptr("testworkspace"),
		// 			Type: to.Ptr("Microsoft.MachineLearningServices/workspaces"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Properties: &armmachinelearning.WorkspaceProperties{
		// 				Description: to.Ptr("test description"),
		// 				ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
		// 				ContainerRegistry: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistry"),
		// 				DiscoveryURL: to.Ptr("http://example.com"),
		// 				FriendlyName: to.Ptr("HelloName"),
		// 				KeyVault: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkv"),
		// 				StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testworkspace"),
		// 			Type: to.Ptr("Microsoft.MachineLearningServices/workspaces"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-5678/providers/Microsoft.MachineLearningServices/workspaces/testworkspace"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Properties: &armmachinelearning.WorkspaceProperties{
		// 				Description: to.Ptr("test description"),
		// 				ApplicationInsights: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/microsoft.insights/components/testinsights"),
		// 				ContainerRegistry: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.ContainerRegistry/registries/testRegistryNew"),
		// 				DiscoveryURL: to.Ptr("http://example.com"),
		// 				FriendlyName: to.Ptr("HelloName"),
		// 				KeyVault: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/workspace-1234/providers/Microsoft.KeyVault/vaults/testkvNew"),
		// 				StorageAccount: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccountOld"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/listNotebookAccessToken.json
func ExampleWorkspacesClient_ListNotebookAccessToken() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().ListNotebookAccessToken(ctx, "workspace-1234", "testworkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NotebookAccessTokenResult = armmachinelearning.NotebookAccessTokenResult{
	// 	ExpiresIn: to.Ptr[int32](28800),
	// 	HostName: to.Ptr("Host product name"),
	// 	NotebookResourceID: to.Ptr("94350843095843059"),
	// 	PublicDNS: to.Ptr("resource.notebooks.azure.net"),
	// 	Scope: to.Ptr("aznb_identity"),
	// 	TokenType: to.Ptr("Bearer"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Notebook/prepare.json
func ExampleWorkspacesClient_BeginPrepareNotebook() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkspacesClient().BeginPrepareNotebook(ctx, "testrg123", "workspaces123", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NotebookResourceInfo = armmachinelearning.NotebookResourceInfo{
	// 	Fqdn: to.Ptr("testnotebook.notebooks.azure.com"),
	// 	NotebookPreparationError: &armmachinelearning.NotebookPreparationError{
	// 		ErrorMessage: to.Ptr("general error"),
	// 		StatusCode: to.Ptr[int32](500),
	// 	},
	// 	ResourceID: to.Ptr("aabbccddee112233445566778899"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Workspace/listStorageAccountKeys.json
func ExampleWorkspacesClient_ListStorageAccountKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().ListStorageAccountKeys(ctx, "testrg123", "workspaces123", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListStorageAccountKeysResult = armmachinelearning.ListStorageAccountKeysResult{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Notebook/listKeys.json
func ExampleWorkspacesClient_ListNotebookKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().ListNotebookKeys(ctx, "testrg123", "workspaces123", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListNotebookKeysResult = armmachinelearning.ListNotebookKeysResult{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/ExternalFQDN/get.json
func ExampleWorkspacesClient_ListOutboundNetworkDependenciesEndpoints() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().ListOutboundNetworkDependenciesEndpoints(ctx, "workspace-1234", "testworkspace", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExternalFQDNResponse = armmachinelearning.ExternalFQDNResponse{
	// 	Value: []*armmachinelearning.FQDNEndpoints{
	// 		{
	// 			Properties: &armmachinelearning.FQDNEndpointsProperties{
	// 				Category: to.Ptr("Azure Active Directory"),
	// 				Endpoints: []*armmachinelearning.FQDNEndpoint{
	// 					{
	// 						DomainName: to.Ptr("login.microsoftonline.com"),
	// 						EndpointDetails: []*armmachinelearning.FQDNEndpointDetail{
	// 							{
	// 								Port: to.Ptr[int32](443),
	// 						}},
	// 				}},
	// 			},
	// 		},
	// 		{
	// 			Properties: &armmachinelearning.FQDNEndpointsProperties{
	// 				Category: to.Ptr("Azure portal"),
	// 				Endpoints: []*armmachinelearning.FQDNEndpoint{
	// 					{
	// 						DomainName: to.Ptr("management.azure.com"),
	// 						EndpointDetails: []*armmachinelearning.FQDNEndpointDetail{
	// 							{
	// 								Port: to.Ptr[int32](443),
	// 						}},
	// 				}},
	// 			},
	// 	}},
	// }
}
