// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forgejo

import (
	"context"
	"fmt"

	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"

	forgejo_sdk "code.forgejo.org/f3/gof3/v3/forges/forgejo/sdk"
)

type milestones struct {
	container
}

func (o *milestones) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	pageSize := o.getPageSize()

	var err error
	var forgejoMilestones []*forgejo_sdk.Milestone

	owner := f3_tree.GetOwnerName(o.GetNode())
	project := f3_tree.GetProjectName(o.GetNode())

	forgejoMilestones, _, err = o.getClient().ListRepoMilestones(owner, project, forgejo_sdk.ListMilestoneOption{
		ListOptions: forgejo_sdk.ListOptions{Page: page, PageSize: pageSize},
	})
	if err != nil {
		panic(fmt.Errorf("error while listing milestones: %v", err))
	}

	return f3_tree.ConvertListed(ctx, o.GetNode(), f3_tree.ConvertToAny(forgejoMilestones...)...)
}

func newMilestones() generic.NodeDriverInterface {
	return &milestones{}
}
